unit fHTMLtoRTF;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TConvertSettings = record
  PreserveTables : integer;             //1 - preserve tables, 0 - transfer to text
  PreserveImages : integer;             //1 - preserve images,  0 - skip
  PreserveHyperlinks : integer;         //1 - preserve hyperlinks, 0 - skip
  PreserveFontFace : integer;           //1 - preserve font faces as in HTML, 0 - all font faces will be as in 'FontFace'
  PreserveFontSize : integer;           //1 - preserve font sizes as in HTML, 0 - all font sizes will be as in 'FontSize'
  PreserveFontColor : integer;          //1 - preserve font colors as in HTML, 0 - black font color
  PreserveBackgroundColor : integer;    //1 - preserve bacground colors as in HTML, 0 - skip
  PreserveAlignment : integer;          //1 - preserve alignment as in HTML, 0 - all text will have align as in 'PageAlignment'
  PreserveTableWidth : integer;         //1 - preserve width of columns
  PreserveNestedTables : integer;       //1 - preserve nested tables, 0 - translate nested tables to plain tables
  PageMarginLeft : integer;             //page margin left, mm. For example 10
  PageMarginRight : integer;            //page margin right, mm. For example 10
  PageMarginTop : integer;              //page margin top, mm. For example 10
  PageMarginBottom : integer;           //page margin bottom, mm. For example 10
  BorderVisibility : integer;           //table borders: 0 - visible borders, 1 - hidden borders, 2 - as in HTML
  PageOrientation : integer;            //page orientation: 0 - Portrait, 1 - Landscape
  PageSize : integer;                   //page size: 0 - A4, 1 - A3, 2 - A5, 3 - B5, 4 - Letter, 5 - Legal, 6 - Executive, 7 - Monarh
  FontFace : integer;                   //default font face: Arial - 0, Times New Roman - 1, Verdana - 2, Helvetica - 3, Courier - 4, Courier New - 5, Times - 6, Georgia - 7, MS Sans Serif - 8,
		                        //Futura - 9, Arial Narrow - 10, Garamond - 11, Impact - 12, Lucida Console - 13, Tahoma - 14, Inform - 15, Symbol - 16, WingDings - 17, Traditional Arabic - 18
  FontSize : integer;                   //default font size, any value from 6 to 72
  PageAlignment : integer;              //page alignment: 0 - left, 1 - center, 2 - right, 3 - justify
  RtfLanguage : integer;                //RTF language: English - 1033, Albanian - 1052, Belgian - 2067, Bulgarian - 1026, Hungarian - 1038, Danish - 1030, Spanish - 3082, Latvian - 1062, Lithuanian - 1063,
                                        //German - 1031, Netherlands - 1043, Norwegian - 2068, Portuguese - 2070, Romanian - 1048, Russian - 1049, Ukrainian - 1058, Finnish - 1035, French - 1036,
                                        //Czech - 1029, Swedish - 1053, Arabic - 1053, Turkish - 1055, Japanese - 932, SimplifiedChinese - 936, TraditionalChinese - 950, Korean - 949, Thai = 874
  Encoding : integer;                   //AutoSelect - 0, ISO-8859-1 - 1, ISO-8859-5 - 2, KOI8-R - 3, Windows-1251 - 4, UTF-8 - 5, Windows-1254 - 6, Windows-1256 - 7,
                        		//Windows-1250 - 8, Windows-1252 - 9, Windows-1253 - 10, Windows-1255 - 11, Windows-1257 - 12, Windows-1258 - 13
  OutputTextFormat : integer;           //Output Format: Rtf - 0, Text - 1, Doc - 2 (only file with .doc extension)  
  PreservePageBreaks : integer;         //1 - preserve page-breaks
  ImageCompatible  : integer;           //type of produced images: Word - 0, WordPad - 1
  PageNumbers : integer;                //page numbers: 0 - disable, 1 - numbers from first page, 2 - from second page
  PageHeader : Array [0..149] of Char;  //page header, any string
  PageFooter : Array [0..149] of Char;  //page footer, any string
  HtmlPath : Array [0..649] of Char;    //html path for method 'htmltortf_string', will be used for find images (now is not used)
  PageNumbersAlignV : integer;          //page numbers vertical align: Top - 4, Bottom - 5
  PageNumbersAlignH : integer;          //page numbers horizontal align: 0 - left, 1 - center, 2 - right, 3 - justify
  PreserveHR : integer;                 //1 - preseve <hr>, 0 - skip
  RtfParts : integer;                	//0 - rtf completely, 1 - only rtf body (to insert inside another rtf files)
  CreateTraceFile : integer;		//1 - the component will create trace file, it helps to see how converting goes and shows errors
  TraceFilePath : Array [0..649] of Char;//specifies path for trace file, for example "c:\\Trace.txt"
  TableCellPadding : integer;		//specifies table cell padding in pixels, any value from 0 to 10
  PreserveHttpImages : integer;		//1- download http images, 0 - skip them

end;

  TForm1 = class(TForm)
    htmlfile: TEdit;
    rtffile: TEdit;
    Button1: TButton;
    result: TLabel;
    htmlstring: TMemo;
    Label1: TLabel;
    rtfstring: TMemo;
    Label2: TLabel;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    FConvertSettings: TConvertSettings;
  public
    { Public declarations }
  end;

  function htmltortf_string(ARTF: string; AHTML: string; AOptions: TConvertSettings): pchar;
  cdecl; external 'htmltortf_sautinsoft.dll' name 'htmltortf_string';
  function htmltortf_file(HtmlFile: pchar; RtfFile: pchar; AOptions: TConvertSettings): integer;
  cdecl; external 'htmltortf_sautinsoft.dll' name 'htmltortf_file';
  function flushlist(): integer;
  cdecl; external 'htmltortf_sautinsoft.dll' name 'flushlist';

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  LoadLibrary('htmltortf_sautinsoft.dll');
  FConvertSettings.PreserveTables:=1;
  FConvertSettings.PreserveImages:=1;
  FConvertSettings.PreserveHyperlinks:=0;
  FConvertSettings.PreserveFontFace:=1;
  FConvertSettings.PreserveFontSize:=1;
  FConvertSettings.PreserveFontColor:=1;
  FConvertSettings.PreserveBackgroundColor:=1;
  FConvertSettings.PreserveAlignment:=1;
  FConvertSettings.PreserveTableWidth:=1;
  FConvertSettings.PreserveNestedTables:=1;
  FConvertSettings.PageMarginLeft:=20;
  FConvertSettings.PageMarginRight:=25;
  FConvertSettings.PageMarginTop:=20;
  FConvertSettings.PageMarginBottom:=20;
  FConvertSettings.BorderVisibility:=1;
  FConvertSettings.PageOrientation:=0;
  FConvertSettings.PageSize:=0;
  FConvertSettings.FontFace:=0;
  FConvertSettings.FontSize:=10;
  FConvertSettings.PageAlignment:=0;
  FConvertSettings.RtfLanguage:=1033;
  FConvertSettings.Encoding:=0;
  FConvertSettings.OutputTextFormat:=0;
  FConvertSettings.PreservePageBreaks:=1;
  FConvertSettings.ImageCompatible:=0;//type of produced images: Word - 0, WordPad - 1
  FConvertSettings.PageNumbers:=0;
  FConvertSettings.PageHeader:='';
  FConvertSettings.PageFooter:='';
  FConvertSettings.HtmlPath:='';
  FConvertSettings.PageNumbersAlignV:=5;
  FConvertSettings.PageNumbersAlignH:=2;
  FConvertSettings.PreserveHR:=1;
  FConvertSettings.RtfParts:=0;
  FConvertSettings.CreateTraceFile:=0;
  FConvertSettings.TraceFilePath:='';
  FConvertSettings.TableCellPadding:=2;
  FConvertSettings.PreserveHttpImages:=1;

end;

procedure TForm1.Button1Click(Sender: TObject);
var
  convert_code:integer;
begin
  convert_code:=htmltortf_file(pchar(htmlfile.Text), pchar(rtffile.Text), FConvertSettings);
  flushlist(); //release memory
  case convert_code of
    0: result.Caption:='Converting OK';
    2: result.Caption:='Not enough memory';
    3: result.Caption:='Can''t create HTML file';
    4: result.Caption:='Can''t open RTF file';
    5: result.Caption:='RTF file has zero length';
  else
       result.Caption:='Unknown Error';
  end;
end;
procedure TForm1.Button2Click(Sender: TObject);
var
  lInString: string;
  lOutString: pchar;
begin
  rtfstring.Clear;
  lInString := htmlstring.Text;
  lOutString :=nil;
  rtfstring.Lines.Text := htmltortf_string(pchar(lInString), lOutString, FConvertSettings);
  flushlist(); //release memory
end;

end.
